/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.features.map;

import cheaters.get.banned.Shady;
import cheaters.get.banned.features.map.MapController;
import cheaters.get.banned.features.map.RoomLists;
import cheaters.get.banned.features.map.elements.MapTile;
import cheaters.get.banned.features.map.elements.doors.DoorTile;
import cheaters.get.banned.features.map.elements.rooms.RoomTile;
import cheaters.get.banned.features.map.elements.rooms.RoomType;
import cheaters.get.banned.features.map.elements.rooms.Separator;
import cheaters.get.banned.gui.config.Config;
import cheaters.get.banned.utils.DungeonUtils;
import cheaters.get.banned.utils.FontUtils;
import cheaters.get.banned.utils.RenderUtils;
import cheaters.get.banned.utils.Utils;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MapView {
    public static int tileSize = 8;
    public static final int maxMapPx = tileSize * 23;
    public static final int maxMapBlocks = 197;
    private static final int borderSize = 3;
    private static ArrayList<String> roomNamesDrawn = new ArrayList();
    private static final ResourceLocation icon_cross = new ResourceLocation("shadyaddons:dungeonscanner/cross.png");
    private static final ResourceLocation icon_whiteCheck = new ResourceLocation("shadyaddons:dungeonscanner/white_check.png");
    private static final ResourceLocation icon_check = new ResourceLocation("shadyaddons:dungeonscanner/check.png");

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (MapController.scannedMap == null || !Utils.inDungeon || !Config.dungeonMap || DungeonUtils.inBoss) {
            return;
        }
        float scale = (float)Config.mapScale / 100.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)(Config.mapXOffset + (Config.mapBorder > 0 ? 3 : 0)), (float)(Config.mapYOffset + (Config.mapBorder > 0 ? 3 : 0)), (float)0.0f);
        Gui.func_73734_a((int)0, (int)0, (int)(maxMapPx + tileSize * 2), (int)(maxMapPx + tileSize * 2 + (Config.showDungeonInfo ? 30 : 0)), (int)Utils.addAlphaPct(Color.BLACK, (float)Config.mapBackgroundOpacity / 100.0f).getRGB());
        if (Config.mapBorder > 0) {
            int borderColor = (new int[]{3, MapView.getChroma(), Color.BLACK.getRGB(), Color.WHITE.getRGB()})[Config.mapBorder];
            int mapWidth = maxMapPx + tileSize * 2;
            int mapHeight = mapWidth + (Config.showDungeonInfo ? 30 : 0);
            Gui.func_73734_a((int)-3, (int)-3, (int)(mapWidth + 3), (int)0, (int)borderColor);
            Gui.func_73734_a((int)-3, (int)-3, (int)0, (int)(mapHeight + 3), (int)borderColor);
            Gui.func_73734_a((int)-3, (int)mapHeight, (int)(mapWidth + 3), (int)(mapHeight + 3), (int)borderColor);
            Gui.func_73734_a((int)mapWidth, (int)-3, (int)(mapWidth + 3), (int)(mapHeight + 3), (int)borderColor);
        }
        if (Config.showDungeonInfo) {
            FontUtils.drawCenteredString(String.format("Secrets: \u00a7a%d\u00a77/%d \u00a7f   Crypts: \u00a7a%d\n\u00a7fDeaths: \u00a7%c%d \u00a7f   Score: \u00a7%c%d", DungeonUtils.secretsFound, MapController.scannedMap.totalSecrets, DungeonUtils.cryptsFound, Character.valueOf(DungeonUtils.deaths > 4 ? (char)'c' : 'a'), DungeonUtils.deaths, Character.valueOf(MapView.getColorCode(DungeonUtils.score, 269, 300)), DungeonUtils.score), maxMapPx / 2 + 10, maxMapPx + 10 + 15);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179109_b((float)tileSize, (float)tileSize, (float)0.0f);
        MapTile[][] elements = MapController.scannedMap.elements;
        for (int rowNum = 0; rowNum < elements.length; ++rowNum) {
            MapTile[] row = elements[rowNum];
            for (int colNum = 0; colNum < row.length; ++colNum) {
                boolean rowEven;
                MapTile tile = row[colNum];
                if (tile == null) continue;
                int x = (int)(Math.ceil((float)colNum / 2.0f) * (double)tileSize * 3.0 + Math.floor((float)colNum / 2.0f) * (double)tileSize);
                int y = (int)(Math.ceil((float)rowNum / 2.0f) * (double)tileSize * 3.0 + Math.floor((float)rowNum / 2.0f) * (double)tileSize);
                boolean colEven = colNum % 2 == 0;
                boolean bl = rowEven = rowNum % 2 == 0;
                if (colEven && rowEven) {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + tileSize * 3), (int)(y + tileSize * 3), (int)tile.color);
                    if (MapView.drawCheckmark((RoomTile)tile, x, y)) continue;
                    MapView.drawRoomName((RoomTile)tile, x, y);
                    continue;
                }
                if (tile instanceof DoorTile) {
                    if (colEven) {
                        Gui.func_73734_a((int)(x + tileSize), (int)y, (int)(x + tileSize * 2), (int)(y + tileSize), (int)tile.color);
                        continue;
                    }
                    Gui.func_73734_a((int)x, (int)(y + tileSize), (int)(x + tileSize), (int)(y + tileSize * 2), (int)tile.color);
                    continue;
                }
                if (!(tile instanceof Separator)) continue;
                if (colEven) {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + tileSize * 3), (int)(y + tileSize), (int)tile.color);
                    continue;
                }
                if (rowEven) {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + tileSize), (int)(y + tileSize * 3), (int)tile.color);
                    continue;
                }
                Gui.func_73734_a((int)x, (int)y, (int)(x + tileSize), (int)(y + tileSize), (int)tile.color);
            }
        }
        if (Config.showMapPlayerHeads > 0) {
            int headSize = 14;
            for (EntityPlayer teammate : DungeonUtils.teammates) {
                if (Config.showMapPlayerHeads == 2 && teammate != Shady.mc.field_71439_g || teammate.field_70128_L) continue;
                int playerX = (int)((float)(teammate.func_180425_c().func_177958_n() - -200) / 197.0f * (float)maxMapPx);
                int playerZ = (int)((float)(teammate.func_180425_c().func_177952_p() - -200) / 197.0f * (float)maxMapPx);
                int playerRotation = (int)(teammate.func_70079_am() - 180.0f);
                MapView.drawPlayerIcon(teammate, headSize, playerX - headSize / 2, playerZ - headSize / 2, playerRotation);
            }
        }
        GlStateManager.func_179109_b((float)(-tileSize), (float)(-tileSize), (float)0.0f);
        GlStateManager.func_179109_b((float)(-Config.mapXOffset - (Config.mapBorder > 0 ? 3 : 0)), (float)(-Config.mapYOffset - (Config.mapBorder > 0 ? 3 : 0)), (float)0.0f);
        GlStateManager.func_179121_F();
        roomNamesDrawn.clear();
    }

    private static void drawPlayerIcon(EntityPlayer player, int size, int x, int y, int angle) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + (float)size / 2.0f), (float)((float)y + (float)size / 2.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)(-x) - (float)size / 2.0f), (float)((float)(-y) - (float)size / 2.0f), (float)0.0f);
        Gui.func_73734_a((int)x, (int)y, (int)(x + size), (int)(y + size), (int)Color.BLACK.getRGB());
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        RenderUtils.drawPlayerIcon(player, size - 2, x + 1, y + 1);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
        GlStateManager.func_179121_F();
    }

    private static boolean drawCheckmark(RoomTile room, int x, int y) {
        ResourceLocation resourceLocation;
        switch (room.status) {
            case FAILED: {
                resourceLocation = icon_cross;
                break;
            }
            case CLEARED: {
                resourceLocation = icon_whiteCheck;
                break;
            }
            case GREEN: {
                resourceLocation = icon_check;
                break;
            }
            default: {
                return false;
            }
        }
        RenderUtils.drawTexture(resourceLocation, x + (int)((double)tileSize * 0.75), y + (int)((double)tileSize * 0.75), (int)((double)tileSize * 1.5), (int)((double)tileSize * 1.5));
        return true;
    }

    private static void drawRoomName(RoomTile roomTile, int x, int y) {
        if (Config.showRoomNames == 0) {
            return;
        }
        String name = null;
        if (Config.showRoomNames == 1) {
            if ((roomTile.room.type == RoomType.YELLOW || roomTile.room.type == RoomType.PUZZLE || roomTile.room.type == RoomType.TRAP) && (name = RoomLists.shortNames.get(roomTile.room.name)) == null) {
                name = roomTile.room.name.replace(" ", "\n");
            }
        } else if (Config.showRoomNames == 2) {
            if (roomNamesDrawn.contains(roomTile.room.name)) {
                return;
            }
            name = roomTile.room.name.replace(" ", "\n");
            roomNamesDrawn.add(roomTile.room.name);
        }
        if (name == null) {
            return;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        FontUtils.drawCenteredString(name, (int)((double)x + (double)tileSize * 1.5), (int)((double)y + (double)tileSize * 1.5));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-100.0f);
    }

    private static char getColorCode(int value, int orangeAfter, int greenAfter) {
        if (value < orangeAfter) {
            return 'c';
        }
        if (value < greenAfter) {
            return '6';
        }
        return 'a';
    }

    private static int getChroma() {
        float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        return Color.getHSBColor(hue, 0.75f, 1.0f).getRGB();
    }
}

