/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.features;

import cheaters.get.banned.Shady;
import cheaters.get.banned.events.TickEndEvent;
import cheaters.get.banned.gui.config.Config;
import cheaters.get.banned.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AutoTerminals {
    private static final ArrayList<Slot> clickQueue = new ArrayList(28);
    private static final int[] mazeDirection = new int[]{-9, -1, 1, 9};
    private static TerminalType currentTerminal = TerminalType.NONE;
    private static int targetColorIndex = -1;
    private static long lastClickTime = 0L;
    private static int windowId = 0;
    private static int windowClicks = 0;
    private static boolean recalculate = false;
    public static boolean testing = false;
    private static final ArrayList<Integer> colorOrder = new ArrayList<Integer>(Arrays.asList(14, 1, 4, 13, 11));

    @SubscribeEvent
    public void onGuiDraw(GuiScreenEvent.BackgroundDrawnEvent event) {
        Container container;
        if (!Config.autoTerminals || !Utils.inDungeon) {
            return;
        }
        if (event.gui instanceof GuiChest && (container = ((GuiChest)event.gui).field_147002_h) instanceof ContainerChest) {
            List invSlots = container.field_75151_b;
            if (currentTerminal == TerminalType.NONE) {
                String chestName = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
                Utils.log("Chest name: " + chestName);
                if (chestName.equals("Navigate the maze!")) {
                    currentTerminal = TerminalType.MAZE;
                } else if (chestName.equals("Click in order!")) {
                    currentTerminal = TerminalType.NUMBERS;
                } else if (chestName.equals("Correct all the panes!")) {
                    currentTerminal = TerminalType.CORRECT_ALL;
                } else if (chestName.startsWith("What starts with: '")) {
                    currentTerminal = TerminalType.LETTER;
                } else if (chestName.startsWith("Select all the")) {
                    currentTerminal = TerminalType.COLOR;
                } else if (chestName.equals("Change all to same color!")) {
                    currentTerminal = TerminalType.TOGGLE_COLOR;
                }
            }
            if (currentTerminal != TerminalType.NONE) {
                if (clickQueue.isEmpty() || recalculate) {
                    recalculate = this.getClicks((ContainerChest)container);
                } else {
                    switch (currentTerminal) {
                        case MAZE: 
                        case NUMBERS: 
                        case CORRECT_ALL: {
                            clickQueue.removeIf(slot -> ((Slot)invSlots.get(slot.field_75222_d)).func_75216_d() && ((Slot)invSlots.get(slot.field_75222_d)).func_75211_c().func_77952_i() == 5);
                            break;
                        }
                        case LETTER: 
                        case COLOR: {
                            clickQueue.removeIf(slot -> ((Slot)invSlots.get(slot.field_75222_d)).func_75216_d() && ((Slot)invSlots.get(slot.field_75222_d)).func_75211_c().func_77948_v());
                            break;
                        }
                        case TOGGLE_COLOR: {
                            clickQueue.removeIf(slot -> ((Slot)invSlots.get(slot.field_75222_d)).func_75216_d() && ((Slot)invSlots.get(slot.field_75222_d)).func_75211_c().func_77952_i() == targetColorIndex);
                        }
                    }
                }
                if (!clickQueue.isEmpty() && Config.autoTerminals && System.currentTimeMillis() - lastClickTime > (long)Config.terminalClickDelay) {
                    this.clickSlot(clickQueue.get(0));
                }
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEndEvent event) {
        if (!Config.autoTerminals || !Utils.inDungeon) {
            return;
        }
        if (Shady.mc.field_71439_g == null || Shady.mc.field_71441_e == null) {
            return;
        }
        if (!(Shady.mc.field_71462_r instanceof GuiChest)) {
            AutoTerminals.reset();
        }
    }

    private static void reset() {
        currentTerminal = TerminalType.NONE;
        clickQueue.clear();
        windowClicks = 0;
        targetColorIndex = -1;
    }

    private boolean getClicks(ContainerChest container) {
        List invSlots = container.field_75151_b;
        String chestName = container.func_85151_d().func_145748_c_().func_150260_c();
        clickQueue.clear();
        switch (currentTerminal) {
            case MAZE: {
                int[] mazeDirection = new int[]{-9, -1, 1, 9};
                boolean[] isStartSlot = new boolean[54];
                int endSlot = -1;
                for (Slot slot : invSlots) {
                    ItemStack itemStack;
                    if (slot.field_75224_c == Shady.mc.field_71439_g.field_71071_by || (itemStack = slot.func_75211_c()) == null || itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150397_co)) continue;
                    if (itemStack.func_77952_i() == 5) {
                        isStartSlot[slot.field_75222_d] = true;
                        continue;
                    }
                    if (itemStack.func_77952_i() != 14) continue;
                    endSlot = slot.field_75222_d;
                }
                for (int slot = 0; slot < 54; ++slot) {
                    if (!isStartSlot[slot]) continue;
                    boolean[] mazeVisited = new boolean[54];
                    int startSlot = slot;
                    while (startSlot != endSlot) {
                        boolean newSlotChosen = false;
                        for (int i : mazeDirection) {
                            ItemStack itemStack;
                            int nextSlot = startSlot + i;
                            if (nextSlot < 0 || nextSlot > 53 || i == -1 && startSlot % 9 == 0 || i == 1 && startSlot % 9 == 8) continue;
                            if (nextSlot == endSlot) {
                                return false;
                            }
                            if (mazeVisited[nextSlot] || (itemStack = ((Slot)invSlots.get(nextSlot)).func_75211_c()) == null || itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150397_co) || itemStack.func_77952_i() != 0) continue;
                            clickQueue.add((Slot)invSlots.get(nextSlot));
                            startSlot = nextSlot;
                            mazeVisited[nextSlot] = true;
                            newSlotChosen = true;
                            break;
                        }
                        if (newSlotChosen) continue;
                        System.out.println("Maze calculation aborted");
                        return true;
                    }
                }
                return true;
            }
            case NUMBERS: {
                int min = 0;
                Slot[] temp = new Slot[14];
                for (int i = 10; i <= 25; ++i) {
                    ItemStack itemStack;
                    if (i == 17 || i == 18 || (itemStack = ((Slot)invSlots.get(i)).func_75211_c()) == null || itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150397_co) || itemStack.field_77994_a >= 15) continue;
                    if (itemStack.func_77952_i() == 14) {
                        temp[itemStack.field_77994_a - 1] = (Slot)invSlots.get(i);
                        continue;
                    }
                    if (itemStack.func_77952_i() != 5 || min >= itemStack.field_77994_a) continue;
                    min = itemStack.field_77994_a;
                }
                clickQueue.addAll(Arrays.stream(temp).filter(Objects::nonNull).collect(Collectors.toList()));
                if (clickQueue.size() == 14 - min) break;
                return true;
            }
            case CORRECT_ALL: {
                for (Slot slot : invSlots) {
                    if (slot.field_75224_c == Shady.mc.field_71439_g.field_71071_by || slot.field_75222_d < 9 || slot.field_75222_d > 35 || slot.field_75222_d % 9 <= 1 || slot.field_75222_d % 9 >= 7) continue;
                    ItemStack itemStack = slot.func_75211_c();
                    if (itemStack == null) {
                        return true;
                    }
                    if (itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150397_co) || itemStack.func_77952_i() != 14) continue;
                    clickQueue.add(slot);
                }
                break;
            }
            case LETTER: {
                if (chestName.length() <= chestName.indexOf("'") + 1) break;
                char letterNeeded = chestName.charAt(chestName.indexOf("'") + 1);
                for (Slot slot : invSlots) {
                    if (slot.field_75224_c == Shady.mc.field_71439_g.field_71071_by || slot.field_75222_d < 9 || slot.field_75222_d > 44 || slot.field_75222_d % 9 == 0 || slot.field_75222_d % 9 == 8) continue;
                    ItemStack itemStack = slot.func_75211_c();
                    if (itemStack == null) {
                        return true;
                    }
                    if (itemStack.func_77948_v() || StringUtils.func_76338_a((String)itemStack.func_82833_r()).charAt(0) != letterNeeded) continue;
                    clickQueue.add(slot);
                }
                break;
            }
            case COLOR: {
                String colorNeeded = null;
                for (EnumDyeColor color : EnumDyeColor.values()) {
                    String colorName = color.func_176610_l().replaceAll("_", " ").toUpperCase();
                    if (!chestName.contains(colorName)) continue;
                    colorNeeded = color.func_176762_d();
                    break;
                }
                if (colorNeeded == null) break;
                for (Slot slot : invSlots) {
                    if (slot.field_75224_c == Shady.mc.field_71439_g.field_71071_by || slot.field_75222_d < 9 || slot.field_75222_d > 44 || slot.field_75222_d % 9 == 0 || slot.field_75222_d % 9 == 8) continue;
                    ItemStack itemStack = slot.func_75211_c();
                    if (itemStack == null) {
                        return true;
                    }
                    if (itemStack.func_77948_v() || !itemStack.func_77977_a().contains(colorNeeded)) continue;
                    clickQueue.add(slot);
                }
                break;
            }
            case TOGGLE_COLOR: {
                for (Slot slot : invSlots) {
                    boolean leftClick;
                    ItemStack itemStack;
                    if (slot.field_75224_c == Shady.mc.field_71439_g.field_71071_by) continue;
                    if (targetColorIndex == -1) {
                        targetColorIndex = AutoTerminals.getTargetColorIndex(Shady.mc.field_71439_g.field_71070_bA.field_75151_b);
                    }
                    if ((itemStack = slot.func_75211_c()) == null || !colorOrder.contains(itemStack.func_77952_i())) continue;
                    boolean bl = leftClick = (colorOrder.indexOf(targetColorIndex) - colorOrder.indexOf(itemStack.func_77952_i()) + colorOrder.size()) % colorOrder.size() < Math.round((float)colorOrder.size() / 2.0f);
                    if (leftClick) {
                        clickQueue.add(slot);
                        continue;
                    }
                    this.clickSlot(slot, 1, 0);
                }
                if (targetColorIndex == -1) break;
                Utils.log(targetColorIndex);
            }
        }
        return false;
    }

    private static int getTargetColorIndex(List<Slot> slots) {
        if (slots.isEmpty()) {
            return 15;
        }
        float sum = 0.0f;
        for (Slot slot : slots) {
            ItemStack stack;
            if (slot == null || (stack = slot.func_75211_c()) == null) continue;
            sum += (float)colorOrder.indexOf(stack.func_77952_i());
        }
        int index = Math.round(sum / (float)slots.size());
        return colorOrder.size() > index ? index : -1;
    }

    private void clickSlot(Slot slot) {
        if (testing) {
            this.clickSlot(slot, 0, 1);
        } else {
            this.clickSlot(slot, 2, 0);
        }
    }

    private void clickSlot(Slot slot, int clickButton, int clickMode) {
        if (windowClicks == 0) {
            windowId = Shady.mc.field_71439_g.field_71070_bA.field_75152_c;
        }
        Shady.mc.field_71442_b.func_78753_a(windowId + windowClicks, slot.field_75222_d, clickButton, clickMode, (EntityPlayer)Shady.mc.field_71439_g);
        lastClickTime = System.currentTimeMillis();
        if (Config.terminalHalfTrip) {
            ++windowClicks;
            clickQueue.remove(slot);
        }
    }

    private static enum TerminalType {
        MAZE,
        NUMBERS,
        CORRECT_ALL,
        LETTER,
        COLOR,
        NONE,
        TOGGLE_COLOR,
        TIMING;

    }
}

