/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.features.routines;

import cheaters.get.banned.Shady;
import cheaters.get.banned.events.MinuteEvent;
import cheaters.get.banned.events.PacketEvent;
import cheaters.get.banned.events.SendChatMessageEvent;
import cheaters.get.banned.events.TickEndEvent;
import cheaters.get.banned.features.routines.Routine;
import cheaters.get.banned.features.routines.Routines;
import cheaters.get.banned.features.routines.triggers.ChatReceivedTrigger;
import cheaters.get.banned.features.routines.triggers.CommandTrigger;
import cheaters.get.banned.features.routines.triggers.KeybindTrigger;
import cheaters.get.banned.features.routines.triggers.PositionTrigger;
import cheaters.get.banned.features.routines.triggers.SecondIntervalTrigger;
import cheaters.get.banned.features.routines.triggers.TimeOfDayTrigger;
import cheaters.get.banned.features.routines.triggers.Trigger;
import cheaters.get.banned.features.routines.triggers.WorldLoadTrigger;
import java.util.Map;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;

public class RoutineHooks {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        RoutineHooks.runTrigger(KeybindTrigger.class, (Event)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatSent(SendChatMessageEvent event) {
        RoutineHooks.runTrigger(CommandTrigger.class, event);
    }

    @SubscribeEvent
    public void onChatReceived(PacketEvent.ReceiveEvent event) {
        if (event.packet instanceof S02PacketChat) {
            RoutineHooks.runTrigger(ChatReceivedTrigger.class, event);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        RoutineHooks.runTrigger(WorldLoadTrigger.class, (Event)event);
    }

    @SubscribeEvent
    public void onMinute(MinuteEvent event) {
        RoutineHooks.runTrigger(TimeOfDayTrigger.class, event);
    }

    @SubscribeEvent
    public void onTick(TickEndEvent event) {
        if (event.every(3)) {
            RoutineHooks.runTrigger(PositionTrigger.class, event);
        }
        if (event.every(20)) {
            RoutineHooks.runTrigger(SecondIntervalTrigger.class, event);
        }
    }

    private static void runTrigger(Class<? extends Trigger> triggerClass, Event event) {
        if (Shady.mc.field_71441_e == null) {
            return;
        }
        for (Map.Entry<Trigger, Routine> routine : Routines.routines.entrySet()) {
            if (routine.getKey().getClass() != triggerClass || !routine.getKey().shouldTrigger(event)) continue;
            routine.getValue().doActions();
            if (!routine.getKey().shouldCancelEvent) continue;
            event.setCanceled(true);
        }
    }
}

