/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.remote;

import cheaters.get.banned.Shady;
import cheaters.get.banned.utils.HttpUtils;
import cheaters.get.banned.utils.PatchedGIFReader;
import cheaters.get.banned.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.codec.digest.DigestUtils;

public class Capes {
    private static HashMap<String, String> playerCapes = new HashMap();
    private static HashMap<String, ResourceLocation> capes = new HashMap();
    private static HashMap<String, ArrayList<ResourceLocation>> animatedCapes = new HashMap();
    public static final File capesDir = new File(Shady.dir, "cape-cache");

    public static ResourceLocation getCape(NetworkPlayerInfo player) {
        String userHash = DigestUtils.md5Hex((String)player.func_178845_a().getId().toString().replace("-", ""));
        String capeName = playerCapes.get(userHash);
        if (capeName == null) {
            return null;
        }
        if (capeName.endsWith("_anim")) {
            return Capes.getAnimatedCape(capeName);
        }
        return capes.get(capeName);
    }

    private static ResourceLocation getAnimatedCape(String capeName) {
        ArrayList<ResourceLocation> capeFrames = animatedCapes.get(capeName);
        if (capeFrames == null) {
            return null;
        }
        return capeFrames.get((int)(System.currentTimeMillis() / 83L % (long)capeFrames.size()));
    }

    public static void load() {
        Utils.log("Downloading capes...");
        capesDir.mkdirs();
        try {
            String capeJson = HttpUtils.get("https://shadyaddons.com/api/capes");
            JsonObject json = (JsonObject)new Gson().fromJson(capeJson, JsonObject.class);
            JsonObject jsonCapes = json.get("capes").getAsJsonObject();
            JsonObject jsonOwners = json.get("purchased").getAsJsonObject();
            for (Map.Entry element : jsonCapes.entrySet()) {
                String capeName = (String)element.getKey();
                String capeUrl = ((JsonElement)element.getValue()).getAsString();
                Utils.log("Loading cape: " + capeName + " (" + capeUrl + ")");
                if (capeName.endsWith("_anim")) {
                    animatedCapes.put(capeName, Capes.animatedCapeFromFile(capeName, capeUrl));
                    continue;
                }
                capes.put(capeName, Capes.capeFromFile(capeName, capeUrl));
            }
            for (Map.Entry capeOwner : jsonOwners.entrySet()) {
                playerCapes.put((String)capeOwner.getKey(), ((JsonElement)capeOwner.getValue()).getAsString());
            }
        }
        catch (Exception exception) {
            Utils.log("Error downloading capes");
            exception.printStackTrace();
        }
    }

    private static ResourceLocation capeFromFile(String capeName, String capeUrl) {
        try {
            File file = new File(capesDir, capeName + ".png");
            if (!file.exists()) {
                Files.copy(new URL(capeUrl).openStream(), file.toPath(), new CopyOption[0]);
            }
            return Shady.mc.func_110434_K().func_110578_a("shadyaddons", new DynamicTexture(ImageIO.read(file)));
        }
        catch (Exception exception) {
            Utils.log("Error loading cape from file/URL");
            exception.printStackTrace();
            return null;
        }
    }

    private static ArrayList<ResourceLocation> animatedCapeFromFile(String capeName, String capeUrl) {
        try {
            File file = new File(capesDir, capeName + ".gif");
            if (!file.exists()) {
                Files.copy(new URL(capeUrl).openStream(), file.toPath(), new CopyOption[0]);
            }
            PatchedGIFReader reader = new PatchedGIFReader(null);
            ImageInputStream stream = ImageIO.createImageInputStream(file);
            reader.setInput(stream);
            ArrayList<ResourceLocation> frames = new ArrayList<ResourceLocation>();
            int frameCount = ((ImageReader)reader).getNumImages(true);
            for (int i = 0; i < frameCount; ++i) {
                BufferedImage frame = reader.read(i);
                ResourceLocation frameImage = Shady.mc.func_110434_K().func_110578_a("shadyaddons", new DynamicTexture(frame));
                frames.add(frameImage);
            }
            return frames.isEmpty() ? null : frames;
        }
        catch (Exception exception) {
            Utils.log("Error loading animated cape from file/URL");
            exception.printStackTrace();
            return null;
        }
    }
}

