/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.utils;

import cheaters.get.banned.Shady;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import net.minecraft.util.ResourceLocation;

public class EstonianUtils {
    private static HashMap<String, String> englishToEstonian = new HashMap();
    private static final File folkSongFile = new File(Shady.dir, "folk-music.wav");

    public static boolean isEstoniaDay() {
        int month = Calendar.getInstance().get(2);
        int day = Calendar.getInstance().get(5);
        return month == 3 && day == 1;
    }

    public static void loadEstonian() {
        try {
            EstonianUtils.downloadFolkSong();
            ResourceLocation estonianFile = new ResourceLocation("shadyaddons:estonian.json");
            BufferedReader estonianReader = new BufferedReader(new InputStreamReader(Shady.mc.func_110442_L().func_110536_a(estonianFile).func_110527_b()));
            JsonObject estonianJson = new JsonParser().parse((Reader)estonianReader).getAsJsonObject();
            for (Map.Entry pair : estonianJson.entrySet()) {
                englishToEstonian.put((String)pair.getKey(), ((JsonElement)pair.getValue()).getAsString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String replaceEstonian(String notEstonian) {
        if (notEstonian == null) {
            return null;
        }
        for (Map.Entry<String, String> pair : englishToEstonian.entrySet()) {
            String estonian = notEstonian.replace(pair.getKey(), pair.getValue());
            if (estonian.equals(notEstonian)) continue;
            return estonian;
        }
        return notEstonian;
    }

    public static void playFolkSong() {
        try {
            if (!folkSongFile.exists()) {
                return;
            }
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(folkSongFile);
            Clip clip = AudioSystem.getClip();
            clip.open(audioInputStream);
            clip.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void downloadFolkSong() {
        if (folkSongFile.exists()) {
            return;
        }
        try {
            Files.copy(new URL("https://shadyaddons.com/assets/folk-music.wav").openStream(), folkSongFile.toPath(), new CopyOption[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

