/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.features.map;

import cheaters.get.banned.Shady;
import cheaters.get.banned.features.map.MapController;
import cheaters.get.banned.features.map.MapModel;
import cheaters.get.banned.features.map.elements.MapTile;
import cheaters.get.banned.features.map.elements.doors.DoorTile;
import cheaters.get.banned.features.map.elements.doors.DoorType;
import cheaters.get.banned.features.map.elements.rooms.Room;
import cheaters.get.banned.features.map.elements.rooms.RoomTile;
import cheaters.get.banned.features.map.elements.rooms.RoomType;
import cheaters.get.banned.features.map.elements.rooms.Separator;
import cheaters.get.banned.utils.Utils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import org.apache.commons.lang3.StringUtils;

public class MapScanner {
    public static final int xCorner = -200;
    public static final int zCorner = -200;
    public static final int halfRoom = 16;
    private static boolean isScanning = false;

    public static MapModel getScan() {
        MapModel map = new MapModel();
        for (int col = 0; col <= 10; ++col) {
            for (int row = 0; row <= 10; ++row) {
                boolean colEven;
                int x = -185 + col * 16;
                int z = -185 + row * 16;
                if (!Shady.mc.field_71441_e.func_72964_e(x >> 4, z >> 4).func_177410_o()) {
                    Utils.log("Chunk at x" + x + " z" + z + "is not loaded");
                    map.allLoaded = false;
                }
                if (MapScanner.isColumnAir(x, z)) continue;
                boolean rowEven = row % 2 == 0;
                boolean bl = colEven = col % 2 == 0;
                if (rowEven && colEven) {
                    RoomTile roomTile = MapScanner.getRoomTile(x, z);
                    map.elements[row][col] = roomTile;
                    if (roomTile != null && roomTile.room != null) {
                        if (!map.uniqueRooms.contains(roomTile.room)) {
                            map.totalSecrets += roomTile.room.secrets;
                        }
                        map.uniqueRooms.add(roomTile.room);
                    }
                    map.roomTiles.add(roomTile);
                    continue;
                }
                if (!rowEven && !colEven) {
                    if (!(map.elements[row - 1][col - 1] instanceof RoomTile)) continue;
                    map.elements[row][col] = Separator.GENERIC;
                    continue;
                }
                if (MapScanner.isDoor(x, z)) {
                    map.elements[row][col] = MapScanner.getDoor(x, z);
                    continue;
                }
                MapTile tileToCheck = map.elements[rowEven ? row : row - 1][rowEven ? col - 1 : col];
                if (!(tileToCheck instanceof RoomTile)) continue;
                map.elements[row][col] = ((RoomTile)tileToCheck).room.type == RoomType.ENTRANCE ? new DoorTile(DoorType.ENTRANCE) : Separator.GENERIC;
            }
        }
        return map;
    }

    @Nullable
    private static RoomTile getRoomTile(int x, int z) {
        int core = MapScanner.getCore(x, z);
        Room room = MapController.rooms.get(core);
        if (room == null) {
            return null;
        }
        return new RoomTile(room);
    }

    private static boolean isDoor(int x, int z) {
        boolean xPlus4 = MapScanner.isColumnAir(x + 4, z);
        boolean xMinus4 = MapScanner.isColumnAir(x - 4, z);
        boolean zPlus4 = MapScanner.isColumnAir(x, z + 4);
        boolean zMinus4 = MapScanner.isColumnAir(x, z - 4);
        return xPlus4 && xMinus4 && !zPlus4 && !zMinus4 || !xPlus4 && !xMinus4 && zPlus4 && zMinus4;
    }

    private static DoorTile getDoor(int x, int z) {
        IBlockState blockState = Shady.mc.field_71441_e.func_180495_p(new BlockPos(x, 69, z));
        Block block = blockState.func_177230_c();
        DoorType type = null;
        if (block == Blocks.field_150402_ci) {
            type = DoorType.WITHER;
        }
        if (block == Blocks.field_150418_aU) {
            type = DoorType.ENTRANCE;
        }
        if (block == Blocks.field_150406_ce && Blocks.field_150406_ce.func_176201_c(blockState) == 14) {
            type = DoorType.BLOOD;
        }
        if (type == null) {
            type = DoorType.NORMAL;
        }
        return new DoorTile(type);
    }

    public static int getCore(int x, int z) {
        ArrayList<Integer> blocks = new ArrayList<Integer>();
        for (int y = 140; y >= 12; --y) {
            int id = Block.func_149682_b((Block)Shady.mc.field_71441_e.func_180495_p(new BlockPos(x, y, z)).func_177230_c());
            if (id == 5 || id == 54) continue;
            blocks.add(id);
        }
        return StringUtils.join((Object[])blocks.toArray()).hashCode();
    }

    private static boolean isColumnAir(int x, int z) {
        for (int y = 12; y < 140; ++y) {
            if (Shady.mc.field_71441_e.func_175623_d(new BlockPos(x, y, z))) continue;
            return false;
        }
        return true;
    }

    private static void setBlock(Block block, int x, int z) {
        Shady.mc.field_71441_e.func_175656_a(new BlockPos(x, 255, z), block.func_176223_P());
    }
}

