/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.gui.config;

import cheaters.get.banned.Shady;
import cheaters.get.banned.gui.config.Config;
import cheaters.get.banned.gui.config.Property;
import cheaters.get.banned.gui.config.TypeMismatchException;
import cheaters.get.banned.gui.config.settings.BooleanSetting;
import cheaters.get.banned.gui.config.settings.ButtonSetting;
import cheaters.get.banned.gui.config.settings.DoNotSave;
import cheaters.get.banned.gui.config.settings.FolderSetting;
import cheaters.get.banned.gui.config.settings.NumberSetting;
import cheaters.get.banned.gui.config.settings.ParentSetting;
import cheaters.get.banned.gui.config.settings.SelectSetting;
import cheaters.get.banned.gui.config.settings.Setting;
import cheaters.get.banned.gui.config.settings.SpacerSetting;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigLogic {
    private static String fileName = "config/ShadyAddons.cfg";

    public static ArrayList<Setting> collect(Class<Config> instance, List<String> disabledFeatures) {
        Field[] fields;
        ArrayList<Setting> settings = new ArrayList<Setting>();
        block8: for (Field field : fields = instance.getDeclaredFields()) {
            Property annotation = field.getAnnotation(Property.class);
            if (annotation == null) continue;
            switch (annotation.type()) {
                case BOOLEAN: 
                case CHECKBOX: {
                    if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                        settings.add(new BooleanSetting(annotation, field, annotation.type()));
                        continue block8;
                    }
                    throw new TypeMismatchException("type boolean or Boolean", field.getType().getName());
                }
                case NUMBER: {
                    if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                        settings.add(new NumberSetting(annotation, field));
                        continue block8;
                    }
                    throw new TypeMismatchException("type int or Integer", field.getType().getName());
                }
                case SELECT: {
                    if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                        settings.add(new SelectSetting(annotation, field));
                        continue block8;
                    }
                    throw new TypeMismatchException("type int or Integer", field.getType().getName());
                }
                case BUTTON: {
                    if (field.getType() == Runnable.class) {
                        settings.add(new ButtonSetting(annotation, field));
                        continue block8;
                    }
                    throw new TypeMismatchException("type Runnable", field.getType().getName());
                }
                case FOLDER: {
                    if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                        settings.add(new FolderSetting(annotation, field));
                        continue block8;
                    }
                    throw new TypeMismatchException("type boolean or Boolean", field.getType().getName());
                }
                case SPACER: {
                    settings.add(new SpacerSetting(annotation, field));
                }
            }
        }
        ArrayList<Setting> settingsToRemove = new ArrayList<Setting>();
        for (Setting setting : settings) {
            if (disabledFeatures.contains(setting.name)) {
                settingsToRemove.add(setting);
                continue;
            }
            if (settingsToRemove.contains(setting.parent)) {
                settingsToRemove.add(setting);
                continue;
            }
            if (setting.annotation.parent().equals("")) continue;
            setting.parent = (ParentSetting)ConfigLogic.getSettingByName(setting.annotation.parent(), settings);
            if (setting.parent == null) continue;
            setting.parent.children.add(setting);
        }
        settings.removeAll(settingsToRemove);
        return settings;
    }

    public static Setting getSettingByName(String name, ArrayList<Setting> settings) {
        for (Setting setting : settings) {
            if (!setting.name.equals(name)) continue;
            return setting;
        }
        return null;
    }

    public static Setting getSettingByFieldName(String fieldName, ArrayList<Setting> settings) {
        for (Setting setting : settings) {
            if (setting instanceof ButtonSetting || !setting.field.getName().equals(fieldName)) continue;
            return setting;
        }
        return null;
    }

    public static void save() {
        try {
            HashMap<String, Object> settingsToSave = new HashMap<String, Object>();
            for (Setting setting : Shady.settings) {
                if (setting instanceof DoNotSave) continue;
                settingsToSave.put(setting.field.getName(), setting.get(Object.class));
            }
            String json = new Gson().toJson(settingsToSave);
            Files.write(Paths.get(fileName, new String[0]), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception error) {
            System.out.println("Error saving config file");
            error.printStackTrace();
        }
    }

    public static void load() {
        try {
            File file = new File(fileName);
            if (file.exists()) {
                BufferedReader reader = Files.newBufferedReader(Paths.get(fileName, new String[0]));
                Type type = new TypeToken<HashMap<String, Object>>(){}.getType();
                HashMap settingsFromConfig = (HashMap)new Gson().fromJson((Reader)reader, type);
                for (Map.Entry fromConfig : settingsFromConfig.entrySet()) {
                    Setting beingUpdated = ConfigLogic.getSettingByFieldName((String)fromConfig.getKey(), Shady.settings);
                    if (beingUpdated != null) {
                        if (beingUpdated instanceof NumberSetting || beingUpdated instanceof SelectSetting) {
                            beingUpdated.set(((Double)fromConfig.getValue()).intValue());
                            continue;
                        }
                        beingUpdated.forceSet(fromConfig.getValue());
                        continue;
                    }
                    beingUpdated = ConfigLogic.getSettingByName((String)fromConfig.getKey(), Shady.settings);
                    if (beingUpdated == null) continue;
                    if (beingUpdated instanceof NumberSetting || beingUpdated instanceof SelectSetting) {
                        beingUpdated.set(((Double)fromConfig.getValue()).intValue());
                        continue;
                    }
                    beingUpdated.forceSet(fromConfig.getValue());
                }
            }
        }
        catch (Exception error) {
            System.out.println("Error while loading config file");
            error.printStackTrace();
        }
    }
}

