/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.features.map;

import cheaters.get.banned.Shady;
import cheaters.get.banned.events.TickEndEvent;
import cheaters.get.banned.features.map.MapModel;
import cheaters.get.banned.features.map.MapScanner;
import cheaters.get.banned.features.map.elements.MapTile;
import cheaters.get.banned.features.map.elements.rooms.Room;
import cheaters.get.banned.features.map.elements.rooms.RoomStatus;
import cheaters.get.banned.features.map.elements.rooms.RoomTile;
import cheaters.get.banned.features.map.elements.rooms.RoomType;
import cheaters.get.banned.utils.DungeonUtils;
import cheaters.get.banned.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MapController {
    public static HashMap<Integer, Room> rooms = new HashMap();
    public static HashSet<Room> uniqueRooms = new HashSet();
    public static MapModel scannedMap;
    public static boolean isScanning;
    private static long lastScan;
    public static int[] startCorner;
    public static float multiplier;
    public static int roomSize;

    public static void calibrate() {
        Utils.log("Beginning calibration");
        switch (DungeonUtils.floor) {
            case FLOOR_1: {
                MapController.startCorner[0] = 22;
                MapController.startCorner[1] = 11;
                break;
            }
            case FLOOR_2: 
            case FLOOR_3: {
                MapController.startCorner[0] = 11;
                MapController.startCorner[1] = 11;
                break;
            }
            case FLOOR_4: {
                if (MapController.scannedMap.roomTiles.size() <= 25) break;
                MapController.startCorner[0] = 5;
                MapController.startCorner[1] = 16;
                break;
            }
            default: {
                if (MapController.scannedMap.roomTiles.size() == 30) {
                    MapController.startCorner[0] = 16;
                    MapController.startCorner[1] = 5;
                    break;
                }
                if (MapController.scannedMap.roomTiles.size() == 25) {
                    MapController.startCorner[0] = 11;
                    MapController.startCorner[1] = 11;
                    break;
                }
                MapController.startCorner[0] = 5;
                MapController.startCorner[1] = 5;
            }
        }
        roomSize = DungeonUtils.inFloor(DungeonUtils.Floor.FLOOR_1, DungeonUtils.Floor.FLOOR_2, DungeonUtils.Floor.FLOOR_3, DungeonUtils.Floor.MASTER_1, DungeonUtils.Floor.MASTER_2, DungeonUtils.Floor.MASTER_3) || MapController.scannedMap.roomTiles.size() == 24 ? 18 : 16;
        multiplier = 32.0f / ((float)roomSize + 4.0f);
        Utils.log("Calibration finished");
        Utils.log("  startCorner: " + Arrays.toString(startCorner));
        Utils.log("  roomSize: " + roomSize);
        Utils.log("  multiplier: " + multiplier);
    }

    public static void loadRooms() {
        try {
            ResourceLocation roomsResource = new ResourceLocation("shadyaddons:dungeonscanner/new-rooms.json");
            InputStream inputStream = Shady.mc.func_110442_L().func_110536_a(roomsResource).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            JsonArray roomsArray = json.getAsJsonArray("rooms");
            for (JsonElement roomElement : roomsArray) {
                JsonObject roomObject = roomElement.getAsJsonObject();
                String type = roomObject.get("type").getAsString().toUpperCase();
                String name = roomObject.get("name").getAsString();
                int secrets = roomObject.get("secrets").getAsInt();
                JsonArray cores = roomObject.get("cores").getAsJsonArray();
                Room room = new Room(RoomType.valueOf(type), name, secrets);
                for (JsonElement core : cores) {
                    int coreNumber = core.getAsInt();
                    rooms.put(coreNumber, room);
                }
                uniqueRooms.add(room);
            }
        }
        catch (Exception exception) {
            System.out.println("Error loading dungeon rooms");
            exception.printStackTrace();
        }
    }

    public static void printRooms() {
        for (Room roomTile : uniqueRooms) {
            System.out.println("Name: " + roomTile.name);
            System.out.println("Secrets: " + roomTile.secrets);
            System.out.println("Type: " + roomTile.type.name());
            System.out.println();
        }
    }

    public static void scan() {
        Utils.log("Beginning scan");
        try {
            lastScan = System.currentTimeMillis();
            new Thread(() -> {
                isScanning = true;
                scannedMap = MapScanner.getScan();
                if (MapController.scannedMap.allLoaded) {
                    MapController.calibrate();
                }
                isScanning = false;
            }, "ShadyAddons-DungeonScan").start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean shouldScan() {
        return Utils.inDungeon && !isScanning && System.currentTimeMillis() - lastScan >= 250L && DungeonUtils.floor != null && (scannedMap == null || !MapController.scannedMap.allLoaded);
    }

    @SubscribeEvent
    public void onTick(TickEndEvent event) {
        if (MapController.shouldScan()) {
            MapController.scan();
        }
        if (!Utils.inDungeon) {
            scannedMap = null;
        }
        if (event.every(10) && scannedMap != null && MapController.scannedMap.allLoaded) {
            new Thread(MapController::updateRoomStatuses).start();
        }
    }

    public static void updateRoomStatuses() {
        MapData mapData = MapController.getMapData();
        if (mapData == null) {
            return;
        }
        byte[] mapColors = mapData.field_76198_e;
        Utils.log("Updating room statuses");
        int startX = startCorner[0] + Math.floorDiv(roomSize, 2);
        int startZ = startCorner[1] + Math.floorDiv(roomSize, 2);
        int increment = Math.floorDiv(roomSize, 2) + 2;
        for (int x = 0; x <= 10; ++x) {
            block7: for (int y = 0; y <= 10; ++y) {
                MapTile tile;
                int mapX = startX + x * increment;
                int mapY = startZ + y * increment;
                if (mapX >= 128 || mapY >= 128 || (tile = MapController.scannedMap.elements[y][x]) == null) continue;
                int color = Byte.toUnsignedInt(mapColors[(mapY << 7) + mapX]);
                switch (color) {
                    case 0: 
                    case 85: 
                    case 119: {
                        tile.status = RoomStatus.UNDISCOVERED;
                        continue block7;
                    }
                    case 18: {
                        if (tile instanceof RoomTile) {
                            if (((RoomTile)tile).room.type == RoomType.BLOOD) {
                                tile.status = RoomStatus.DISCOVERED;
                                continue block7;
                            }
                            if (((RoomTile)tile).room.type != RoomType.PUZZLE) continue block7;
                            tile.status = RoomStatus.FAILED;
                            continue block7;
                        }
                        tile.status = RoomStatus.DISCOVERED;
                        continue block7;
                    }
                    case 30: {
                        if (!(tile instanceof RoomTile)) continue block7;
                        if (((RoomTile)tile).room.type == RoomType.ENTRANCE) {
                            tile.status = RoomStatus.DISCOVERED;
                            continue block7;
                        }
                        tile.status = RoomStatus.GREEN;
                        continue block7;
                    }
                    case 34: {
                        tile.status = RoomStatus.CLEARED;
                        continue block7;
                    }
                    default: {
                        tile.status = RoomStatus.DISCOVERED;
                    }
                }
            }
        }
    }

    private static MapData getMapData() {
        if (Shady.mc.field_71439_g == null) {
            return null;
        }
        if (Shady.mc.field_71439_g.field_71071_by == null) {
            return null;
        }
        ItemStack handheldMap = Shady.mc.field_71439_g.field_71071_by.func_70301_a(8);
        if (handheldMap == null || !(handheldMap.func_77973_b() instanceof ItemMap) || !handheldMap.func_82833_r().contains("Magical Map")) {
            return null;
        }
        return ((ItemMap)handheldMap.func_77973_b()).func_77873_a(handheldMap, (World)Shady.mc.field_71441_e);
    }

    static {
        isScanning = false;
        lastScan = 0L;
        startCorner = new int[]{5, 5};
        multiplier = 1.6f;
        roomSize = 16;
    }
}

