/*
 * Decompiled with CFR 0.152.
 */
package cheaters.get.banned.utils;

import cheaters.get.banned.Shady;
import cheaters.get.banned.events.PacketEvent;
import cheaters.get.banned.events.TickEndEvent;
import cheaters.get.banned.utils.ScoreboardUtils;
import cheaters.get.banned.utils.TabUtils;
import cheaters.get.banned.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.util.StringUtils;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DungeonUtils {
    public static Floor floor = null;
    public static int secretsFound = 0;
    public static int cryptsFound = 0;
    public static boolean inBoss = false;
    public static boolean foundMimic = false;
    public static int deaths = 0;
    public static ArrayList<EntityPlayer> teammates = new ArrayList();
    public static boolean activeRun = false;
    public static int score = 0;
    private static final Pattern scorePattern = Pattern.compile("Cleared: [0-9]{1,3}% \\((?<score>[0-9]+)\\)");
    private static final List<String> entryMessages = Arrays.asList("[BOSS] Bonzo: Gratz for making it this far, but I\u2019m basically unbeatable.", "[BOSS] Scarf: This is where the journey ends for you, Adventurers.", "[BOSS] The Professor: I was burdened with terrible news recently...", "[BOSS] Thorn: Welcome Adventurers! I am Thorn, the Spirit! And host of the Vegan Trials!", "[BOSS] Livid: Welcome, you arrive right on time. I am Livid, the Master of Shadows.", "[BOSS] Sadan: So you made it all the way here...and you wish to defy me? Sadan?!", "[BOSS] Maxor: WELL WELL WELL LOOK WHO\u2019S HERE!");
    private static final String[] mimicMessages = new String[]{"Mimic Dead!", "$SKYTILS-DUNGEON-SCORE-MIMIC$", "Child Destroyed!", "Mimic Obliterated!", "Mimic Exorcised!", "Mimic Destroyed!", "Mimic Annhilated!"};

    public static void reset() {
        floor = null;
        secretsFound = 0;
        cryptsFound = 0;
        inBoss = false;
        foundMimic = false;
        deaths = 0;
        teammates.clear();
        activeRun = false;
        score = 0;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatPacket(PacketEvent.ReceiveEvent event) {
        if (Utils.inDungeon && event.packet instanceof S02PacketChat && ((S02PacketChat)event.packet).func_179841_c() != 2) {
            String text = StringUtils.func_76338_a((String)((S02PacketChat)event.packet).func_148915_c().func_150260_c());
            if ("[NPC] Mort: Here, I found this map when I first entered the dungeon.".equals(text)) {
                DungeonUtils.updateTeammates(DungeonUtils.getTabList());
            } else if (entryMessages.contains(text)) {
                inBoss = true;
            } else {
                for (String message : mimicMessages) {
                    if (!text.contains(message)) continue;
                    foundMimic = true;
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityZombie entity;
        if (Utils.inDungeon && !foundMimic && event.entity.getClass() == EntityZombie.class && (entity = (EntityZombie)event.entity).func_70631_g_() && entity.func_82169_q(0) == null && entity.func_82169_q(1) == null && entity.func_82169_q(2) == null && entity.func_82169_q(3) == null) {
            foundMimic = true;
        }
    }

    @SubscribeEvent
    public void onTick(TickEndEvent event) {
        Matcher matcher;
        String scoreLine;
        if (!Utils.inDungeon || !event.every(10)) {
            return;
        }
        if (floor == null && !(activeRun = DungeonUtils.updateFloor())) {
            return;
        }
        List<String> tabList = DungeonUtils.getTabList();
        if (tabList != null) {
            DungeonUtils.updateStats(tabList);
            if (teammates.isEmpty()) {
                DungeonUtils.updateTeammates(tabList);
            }
        }
        if ((scoreLine = ScoreboardUtils.getLineThatContains("Cleared: ")) != null && (matcher = scorePattern.matcher(scoreLine)).matches()) {
            String scoreString = matcher.group("score");
            score = Integer.parseInt(scoreString);
        }
    }

    private static void updateTeammates(List<String> tabList) {
        teammates.clear();
        for (int i = 0; i < 4; ++i) {
            String text = StringUtils.func_76338_a((String)tabList.get(1 + i * 4)).trim();
            String username = text.split(" ")[0];
            if (Objects.equals(username, "")) continue;
            for (EntityPlayer playerEntity : Shady.mc.field_71441_e.field_73010_i) {
                if (!playerEntity.func_70005_c_().equals(username)) continue;
                teammates.add(playerEntity);
            }
        }
    }

    private static boolean updateFloor() {
        String cataLine = ScoreboardUtils.getLineThatContains("The Catacombs");
        if (cataLine != null) {
            for (Floor floorOption : Floor.values()) {
                if (!cataLine.contains(floorOption.name)) continue;
                floor = floorOption;
                return true;
            }
        }
        return false;
    }

    private static void updateStats(List<String> tabList) {
        try {
            for (String item : tabList) {
                String justNumbers;
                if (item.contains("Deaths: ")) {
                    justNumbers = Utils.removeAllExceptNumbersAndPeriods(item = StringUtils.func_76338_a((String)item));
                    if (justNumbers.isEmpty()) continue;
                    deaths = Integer.parseInt(justNumbers);
                    continue;
                }
                if (item.contains("Secrets Found: ") && !item.contains("%")) {
                    justNumbers = Utils.removeAllExceptNumbersAndPeriods(item = StringUtils.func_76338_a((String)item));
                    if (justNumbers.isEmpty()) continue;
                    secretsFound = Integer.parseInt(justNumbers);
                    continue;
                }
                if (!item.contains("Crypts: ") || (justNumbers = Utils.removeAllExceptNumbersAndPeriods(item = StringUtils.func_76338_a((String)item))).isEmpty()) continue;
                cryptsFound = Integer.parseInt(justNumbers);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Utils.sendModMessage("&cException in class DungeonUtils");
        }
    }

    private static List<String> getTabList() {
        List<String> tabList = TabUtils.getTabList();
        if (tabList.size() < 18 || !tabList.get(0).contains("\u00a7r\u00a7b\u00a7lParty \u00a7r\u00a7f(")) {
            return null;
        }
        return tabList;
    }

    public static boolean inFloor(Floor ... floors) {
        for (Floor floorToCheck : floors) {
            if (floorToCheck != floor) continue;
            return true;
        }
        return false;
    }

    public static void debug() {
        if (Utils.inDungeon) {
            Utils.sendModMessage("Floor: " + floor.name());
            Utils.sendModMessage("In Boss: " + inBoss);
            Utils.sendModMessage("Secrets Found: " + secretsFound);
            Utils.sendModMessage("Crypts Found: " + cryptsFound);
            Utils.sendModMessage("Team:");
            for (EntityPlayer teammate : teammates) {
                Utils.sendModMessage("- " + teammate.func_70005_c_());
            }
        } else {
            Utils.sendMessage("You must be in a dungeon to debug a dungeon!");
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        DungeonUtils.reset();
    }

    public static enum Floor {
        ENTERANCE("(E)"),
        FLOOR_1("(F1)"),
        FLOOR_2("(F2)"),
        FLOOR_3("(F3)"),
        FLOOR_4("(F4)"),
        FLOOR_5("(F5)"),
        FLOOR_6("(F6)"),
        FLOOR_7("(F7)"),
        MASTER_1("(M1)"),
        MASTER_2("(M2)"),
        MASTER_3("(M3)"),
        MASTER_4("(M4)"),
        MASTER_5("(M5)"),
        MASTER_6("(M6)"),
        MASTER_7("(M7)");

        public final String name;

        private Floor(String name) {
            this.name = name;
        }
    }
}

